/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipe;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpawnerRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<SpawnerRecipe> {
    @Nonnull
    public SpawnerRecipe fromJson(@Nonnull ResourceLocation recipeId, JsonObject root) {
        ResourceLocation id = new ResourceLocation(root.getAsJsonPrimitive("id").getAsString());
        int power = root.getAsJsonPrimitive("power").getAsInt();
        SpawnerRecipes.MobSpawnAmount item1 = this.readSpawnAmount(root, "item1");
        SpawnerRecipes.MobSpawnAmount item2 = this.readSpawnAmount(root, "item2");
        SpawnerRecipes.MobSpawnAmount item3 = this.readSpawnAmount(root, "item3");
        ResourceLocation entity = new ResourceLocation(root.getAsJsonPrimitive("entity").getAsString());
        return new SpawnerRecipe(id, item1, item2, item3, power, entity);
    }

    private SpawnerRecipes.MobSpawnAmount readSpawnAmount(JsonObject root, String tag) {
        SpawnerRecipes.MobSpawnAmount item1;
        JsonObject item1Object = root.getAsJsonObject(tag);
        float amount = item1Object.get("amount").getAsFloat();
        if (item1Object.has("living")) {
            item1 = new SpawnerRecipes.MobSpawnAmount(Ingredient.f_43901_, amount);
        } else {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)item1Object.get("ingredient"));
            item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        }
        return item1;
    }

    @Nullable
    public SpawnerRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        int power = buffer.readInt();
        SpawnerRecipes.MobSpawnAmount item1 = this.readSpawnAmount(buffer);
        SpawnerRecipes.MobSpawnAmount item2 = this.readSpawnAmount(buffer);
        SpawnerRecipes.MobSpawnAmount item3 = this.readSpawnAmount(buffer);
        ResourceLocation entity = buffer.m_130281_();
        return new SpawnerRecipe(id, item1, item2, item3, power, entity);
    }

    private SpawnerRecipes.MobSpawnAmount readSpawnAmount(FriendlyByteBuf buffer) {
        SpawnerRecipes.MobSpawnAmount item1;
        float amount = buffer.readFloat();
        if (buffer.readBoolean()) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        } else {
            item1 = new SpawnerRecipes.MobSpawnAmount(Ingredient.f_43901_, amount);
        }
        return item1;
    }

    public void toNetwork(FriendlyByteBuf buffer, SpawnerRecipe recipe) {
        buffer.m_130085_(recipe.m_6423_());
        buffer.writeInt(recipe.getSpawnRf());
        this.writeMobAmount(buffer, recipe.getItem1());
        this.writeMobAmount(buffer, recipe.getItem2());
        this.writeMobAmount(buffer, recipe.getItem3());
        buffer.m_130085_(recipe.getEntity());
    }

    private void writeMobAmount(FriendlyByteBuf buffer, SpawnerRecipes.MobSpawnAmount item) {
        boolean hasIngredient = item.getObject() != null;
        buffer.writeFloat(item.getAmount());
        buffer.writeBoolean(hasIngredient);
        if (hasIngredient) {
            item.getObject().m_43923_(buffer);
        }
    }
}

